

************************************************************
************************************************************
***      Retrieving Panel Data from the SOEP 2           ***
***   Creating a Person-Year File (Long Format)          ***
***		    Josef Brderl, Volker Ludwig           	     *** 	   
***		            March 2011                           *** 	   
************************************************************
************************************************************

* Data: SOEP 1984-2009 v26

* This retrieval do-file was generated by SOEPinfo. We want to extract
* "general satisfaction with life" (happiness) from the $P files.
* We specified: 
*           "individuals"
*           "unbalanced"
*           "all sample members"
*           only private households "no"
*           "both" genders
*           all subsamples
*           "both" geographic regions

* SOEPinfo creates a wide-format data set. Therefore, some more programming
* is needed to reshape to long-format (commands see below).


#delimit;

/* --------------------------------------------------------------------  */;  
/*  This command file was generated by SOEPINFO-WWW                      */;
/*  from the SOEP HOMEPAGE: http://www.diw-berlin.de/soep.               */;
/*                                                                       */;
/*      !!! I M P O R T A N T  -  W A R N I N G !!!                      */;
/*  You alone are responsible for contents and appropriate               */;
/*  usage by accepting the usage agreement.                              */;
/* --------------------------------------------------------------------- */;
/*  To copy this command file to your own harddisk:                      */;
/*  Use your mouse or (CNTL-A) to select this text, then "copy"          */;
/*  (CNTL-C) then in your windows application, or in a text              */;
/*  editor, "paste" (CNTL-V).                                            */;
/* --------------------------------------------------------------------  */;
/*                                                                       */;
/*  Please report any errors of the STATA code generated here            */;
/*  to Jan Goebel <jgoebel@diw.de>                                       */;
/* --------------------------------------------------------------------  */;
/*                                                                       */;
/* -----   Here you can customize the paths and options:  -----          */; 
/* -----        Some further explanations:                -----          */;                                                                            
/*  The following                                                        */;                              
/*                                                                       */;                 
/*  global macros (in stata),                                            */;                                          
/*  file handles (in SPSS) or                                            */;                                          
/*  libnames (in SAS)                                                    */;                                  
/*                                                                       */;                 
/*  define the locations for the original SOEP DATA, the directory       */;                                                                               
/*  for temporary files and the destination of the resulting data file.  */;                                                                                    
/*                                                                       */;                 
/*  MY_IN_PATH   = "path/to/your/SOEP/directory/"                        */;                                                              
/*  MY_OUT_PATH  = "path/to/the/directory/for/the/resulting/file/"       */;                                                                               
/*  MY_TEMP_PATH = "path/to/the/directory/for/the/temporary/files/"      */;                                                                                
/*                                                                       */;                 
/*  The correct specification of the path depends on your Operating      */;                                                                                
/*  System and on your SOEP installation, but be sure to use a           */;                                                                           
/*  TRAILING backslash ("\", within Windows) or a                        */;                                                              
/*  TRAILING forward slash ("/", within Unix/Linux).                     */;                                                                 
/*                                                                       */;                 
/*  You can also change the name for the resulting data file with the    */;                                                                                  
/*  variable MY_OUT_FILE and the name for the log file (only with        */;                                                                              
/*  stata, variable MY_LOG_FILE).                                        */;                                              
/* ----------------------------------------------------------------      */;                                                                                
                                                                                        

/* -----   Here you can customize the paths and options:   ----- */;

global MY_IN_PATH   "K:\lsssm\SOEP\V26Lehrv\";
global MY_OUT_PATH  "U:\work\";
global MY_TEMP_PATH "U:\work\";

global MY_OUT_FILE  ${MY_OUT_PATH}HAPPY1.dta;
global MY_LOG_FILE  ${MY_OUT_PATH}new.log;

log using "${MY_LOG_FILE}", text replace;
set more off;

/* ----------------[ automatically pull PPFAD ]----------------- */;

use    hhnr    persnr  sex     gebjahr psample 
       ahhnr   bhhnr   chhnr   dhhnr   ehhnr   fhhnr   ghhnr   hhhnr   ihhnr  
       jhhnr   khhnr   lhhnr   mhhnr   nhhnr   ohhnr   phhnr   qhhnr   rhhnr  
       shhnr   thhnr   uhhnr   vhhnr   whhnr   xhhnr   yhhnr   zhhnr   
       anetto  bnetto  cnetto  dnetto  enetto  fnetto  gnetto  hnetto  inetto 
       jnetto  knetto  lnetto  mnetto  nnetto  onetto  pnetto  qnetto  rnetto 
       snetto  tnetto  unetto  vnetto  wnetto  xnetto  ynetto  znetto  
       apop    bpop    cpop    dpop    epop    fpop    gpop    hpop    ipop   
       jpop    kpop    lpop    mpop    npop    opop    ppop    qpop    rpop   
       spop    tpop    upop    vpop    wpop    xpop    ypop    zpop
using  "${MY_IN_PATH}ppfad.dta";

/* --------------[ balanced / unbalanced design ]--------------- */;

keep if ( ( anetto > 0 & anetto < 40 ) | ( bnetto > 0 & bnetto < 40 ) | 
          ( cnetto > 0 & cnetto < 40 ) | ( dnetto > 0 & dnetto < 40 ) | 
          ( enetto > 0 & enetto < 40 ) | ( fnetto > 0 & fnetto < 40 ) | 
          ( gnetto > 0 & gnetto < 40 ) | ( hnetto > 0 & hnetto < 40 ) | 
          ( inetto > 0 & inetto < 40 ) | ( jnetto > 0 & jnetto < 40 ) | 
          ( knetto > 0 & knetto < 40 ) | ( lnetto > 0 & lnetto < 40 ) | 
          ( mnetto > 0 & mnetto < 40 ) | ( nnetto > 0 & nnetto < 40 ) | 
          ( onetto > 0 & onetto < 40 ) | ( pnetto > 0 & pnetto < 40 ) | 
          ( qnetto > 0 & qnetto < 40 ) | ( rnetto > 0 & rnetto < 40 ) | 
          ( snetto > 0 & snetto < 40 ) | ( tnetto > 0 & tnetto < 40 ) | 
          ( unetto > 0 & unetto < 40 ) | ( vnetto > 0 & vnetto < 40 ) | 
          ( wnetto > 0 & wnetto < 40 ) | ( xnetto > 0 & xnetto < 40 ) | 
          ( ynetto > 0 & ynetto < 40 ) | ( znetto > 0 & znetto < 40 ) );

/* -----------------[ private housholds only.]------------------ */;

/* -- start comment
keep if ( ( apop == 1 | apop == 2 ) | ( bpop == 1 | bpop == 2 ) |
          ( cpop == 1 | cpop == 2 ) | ( dpop == 1 | dpop == 2 ) |
          ( epop == 1 | epop == 2 ) | ( fpop == 1 | fpop == 2 ) |
          ( gpop == 1 | gpop == 2 ) | ( hpop == 1 | hpop == 2 ) |
          ( ipop == 1 | ipop == 2 ) | ( jpop == 1 | jpop == 2 ) |
          ( kpop == 1 | kpop == 2 ) | ( lpop == 1 | lpop == 2 ) |
          ( mpop == 1 | mpop == 2 ) | ( npop == 1 | npop == 2 ) |
          ( opop == 1 | opop == 2 ) | ( ppop == 1 | ppop == 2 ) |
          ( qpop == 1 | qpop == 2 ) | ( rpop == 1 | rpop == 2 ) |
          ( spop == 1 | spop == 2 ) | ( tpop == 1 | tpop == 2 ) |
          ( upop == 1 | upop == 2 ) | ( vpop == 1 | vpop == 2 ) |
          ( wpop == 1 | wpop == 2 ) | ( xpop == 1 | xpop == 2 ) |
          ( ypop == 1 | ypop == 2 ) | ( zpop == 1 | zpop == 2 ) );
*/;
/* ----------------------[ define sample ]---------------------- */;

keep if ( (psample == 1) | (psample == 2) | (psample == 3) | (psample == 4) |
          (psample == 5) | (psample == 6) | (psample == 7) | (psample == 8) |
          (psample == 9) );

/* -----------------------[ sort ppfad ]------------------------ */;

sort persnr;
save "${MY_TEMP_PATH}ppfad.dta", replace;
clear;

/* -----------------[ automatically pull PHRF ]----------------- */;

use    hhnr    persnr  prgroup 
       aphrf   bphrf   cphrf   dphrf   ephrf   fphrf   gphrf   hphrf   iphrf  
       jphrf   kphrf   lphrf   mphrf   nphrf   ophrf   pphrf   qphrf   rphrf  
       sphrf   tphrf   uphrf   vphrf   wphrf   xphrf   yphrf   zphrf   
       bpbleib cpbleib dpbleib epbleib fpbleib gpbleib hpbleib ipbleib jpbleib
       kpbleib lpbleib mpbleib npbleib opbleib ppbleib qpbleib rpbleib spbleib
       tpbleib upbleib vpbleib wpbleib xpbleib ypbleib zpbleib
using  "${MY_IN_PATH}phrf.dta";

sort  persnr;
save  "${MY_TEMP_PATH}phrf.dta", replace;
clear;

/* --------------[ automatically create pmaster ]--------------- */;

use    "${MY_TEMP_PATH}ppfad.dta";
merge  persnr
using  "${MY_TEMP_PATH}phrf.dta";

drop   if _merge == 2;
drop   _merge;
erase  "${MY_TEMP_PATH}ppfad.dta";
erase  "${MY_TEMP_PATH}phrf.dta";
sort   persnr;
save   "${MY_TEMP_PATH}pmaster.dta", replace;

/* -------------------------( pull ap )------------------------- */;

use    hhnr    ahhnr   persnr  
       ap6801
using "${MY_IN_PATH}ap.dta";

sort persnr;
save "${MY_TEMP_PATH}ap.dta", replace;
clear;

/* -------------------------( pull bp )------------------------- */;

use    hhnr    bhhnr   persnr  
       bp9301
using "${MY_IN_PATH}bp.dta";

sort persnr;
save "${MY_TEMP_PATH}bp.dta", replace;
clear;

/* -------------------------( pull cp )------------------------- */;

use    hhnr    chhnr   persnr  
       cp9601
using "${MY_IN_PATH}cp.dta";

sort persnr;
save "${MY_TEMP_PATH}cp.dta", replace;
clear;

/* -------------------------( pull dp )------------------------- */;

use    hhnr    dhhnr   persnr  
       dp9801
using "${MY_IN_PATH}dp.dta";

sort persnr;
save "${MY_TEMP_PATH}dp.dta", replace;
clear;

/* -------------------------( pull ep )------------------------- */;

use    hhnr    ehhnr   persnr  
       ep89
using "${MY_IN_PATH}ep.dta";

sort persnr;
save "${MY_TEMP_PATH}ep.dta", replace;
clear;

/* -------------------------( pull fp )------------------------- */;

use    hhnr    fhhnr   persnr  
       fp108
using "${MY_IN_PATH}fp.dta";

sort persnr;
save "${MY_TEMP_PATH}fp.dta", replace;
clear;

/* -------------------------( pull gp )------------------------- */;

use    hhnr    ghhnr   persnr  
       gp109
using "${MY_IN_PATH}gp.dta";

sort persnr;
save "${MY_TEMP_PATH}gp.dta", replace;
clear;

/* -----------------------( pull gpost )------------------------ */;

use    hhnr    ghhnr   persnr  
       gp6401e
using "${MY_IN_PATH}gpost.dta";

sort persnr;
save "${MY_TEMP_PATH}gpost.dta", replace;
clear;

/* -------------------------( pull hp )------------------------- */;

use    hhnr    hhhnr   persnr  
       hp10901
using "${MY_IN_PATH}hp.dta";

sort persnr;
save "${MY_TEMP_PATH}hp.dta", replace;
clear;

/* -------------------------( pull ip )------------------------- */;

use    hhnr    ihhnr   persnr  
       ip10901
using "${MY_IN_PATH}ip.dta";

sort persnr;
save "${MY_TEMP_PATH}ip.dta", replace;
clear;

/* -------------------------( pull jp )------------------------- */;

use    hhnr    jhhnr   persnr  
       jp10901
using "${MY_IN_PATH}jp.dta";

sort persnr;
save "${MY_TEMP_PATH}jp.dta", replace;
clear;

/* -------------------------( pull kp )------------------------- */;

use    hhnr    khhnr   persnr  
       kp10401
using "${MY_IN_PATH}kp.dta";

sort persnr;
save "${MY_TEMP_PATH}kp.dta", replace;
clear;

/* -------------------------( pull lp )------------------------- */;

use    hhnr    lhhnr   persnr  
       lp10401
using "${MY_IN_PATH}lp.dta";

sort persnr;
save "${MY_TEMP_PATH}lp.dta", replace;
clear;

/* -------------------------( pull mp )------------------------- */;

use    hhnr    mhhnr   persnr  
       mp11001
using "${MY_IN_PATH}mp.dta";

sort persnr;
save "${MY_TEMP_PATH}mp.dta", replace;
clear;

/* -------------------------( pull np )------------------------- */;

use    hhnr    nhhnr   persnr  
       np11701
using "${MY_IN_PATH}np.dta";

sort persnr;
save "${MY_TEMP_PATH}np.dta", replace;
clear;

/* -------------------------( pull op )------------------------- */;

use    hhnr    ohhnr   persnr  
       op12301
using "${MY_IN_PATH}op.dta";

sort persnr;
save "${MY_TEMP_PATH}op.dta", replace;
clear;

/* -------------------------( pull pp )------------------------- */;

use    hhnr    phhnr   persnr  
       pp13501
using "${MY_IN_PATH}pp.dta";

sort persnr;
save "${MY_TEMP_PATH}pp.dta", replace;
clear;

/* -------------------------( pull qp )------------------------- */;

use    hhnr    qhhnr   persnr  
       qp14301
using "${MY_IN_PATH}qp.dta";

sort persnr;
save "${MY_TEMP_PATH}qp.dta", replace;
clear;

/* -------------------------( pull rp )------------------------- */;

use    hhnr    rhhnr   persnr  
       rp13501
using "${MY_IN_PATH}rp.dta";

sort persnr;
save "${MY_TEMP_PATH}rp.dta", replace;
clear;

/* -------------------------( pull sp )------------------------- */;

use    hhnr    shhnr   persnr  
       sp13501
using "${MY_IN_PATH}sp.dta";

sort persnr;
save "${MY_TEMP_PATH}sp.dta", replace;
clear;

/* -------------------------( pull tp )------------------------- */;

use    hhnr    thhnr   persnr  
       tp14201
using "${MY_IN_PATH}tp.dta";

sort persnr;
save "${MY_TEMP_PATH}tp.dta", replace;
clear;

/* -------------------------( pull up )------------------------- */;

use    hhnr    uhhnr   persnr  
       up14501
using "${MY_IN_PATH}up.dta";

sort persnr;
save "${MY_TEMP_PATH}up.dta", replace;
clear;

/* -------------------------( pull vp )------------------------- */;

use    hhnr    vhhnr   persnr  
       vp154
using "${MY_IN_PATH}vp.dta";

sort persnr;
save "${MY_TEMP_PATH}vp.dta", replace;
clear;

/* -------------------------( pull wp )------------------------- */;

use    hhnr    whhnr   persnr  
       wp142
using "${MY_IN_PATH}wp.dta";

sort persnr;
save "${MY_TEMP_PATH}wp.dta", replace;
clear;

/* -------------------------( pull xp )------------------------- */;

use    hhnr    xhhnr   persnr  
       xp149
using "${MY_IN_PATH}xp.dta";

sort persnr;
save "${MY_TEMP_PATH}xp.dta", replace;
clear;

/* -------------------------( pull yp )------------------------- */;

use    hhnr    yhhnr   persnr  
       yp15501
using "${MY_IN_PATH}yp.dta";

sort persnr;
save "${MY_TEMP_PATH}yp.dta", replace;
clear;

/* -------------------------( pull zp )------------------------- */;

use    hhnr    zhhnr   persnr  
       zp15701
using "${MY_IN_PATH}zp.dta";

sort persnr;
save "${MY_TEMP_PATH}zp.dta", replace;
clear;

/* -----------------( Now merge all together )------------------ */;

use   "${MY_TEMP_PATH}pmaster.dta";
erase "${MY_TEMP_PATH}pmaster.dta";

/* -----------( merge together by person: ALL Waves )----------- */;

/* ------------------------( merge AP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}ap.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}ap.dta";

/* ------------------------( merge BP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}bp.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}bp.dta";

/* ------------------------( merge CP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}cp.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}cp.dta";

/* ------------------------( merge DP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}dp.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}dp.dta";

/* ------------------------( merge EP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}ep.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}ep.dta";

/* ------------------------( merge FP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}fp.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}fp.dta";

/* ------------------------( merge GP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}gp.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}gp.dta";

/* -----------------------( merge GPOST )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}gpost.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}gpost.dta";

/* ------------------------( merge HP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}hp.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}hp.dta";

/* ------------------------( merge IP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}ip.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}ip.dta";

/* ------------------------( merge JP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}jp.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}jp.dta";

/* ------------------------( merge KP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}kp.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}kp.dta";

/* ------------------------( merge LP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}lp.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}lp.dta";

/* ------------------------( merge MP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}mp.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}mp.dta";

/* ------------------------( merge NP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}np.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}np.dta";

/* ------------------------( merge OP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}op.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}op.dta";

/* ------------------------( merge PP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}pp.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}pp.dta";

/* ------------------------( merge QP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}qp.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}qp.dta";

/* ------------------------( merge RP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}rp.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}rp.dta";

/* ------------------------( merge SP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}sp.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}sp.dta";

/* ------------------------( merge TP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}tp.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}tp.dta";

/* ------------------------( merge UP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}up.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}up.dta";

/* ------------------------( merge VP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}vp.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}vp.dta";

/* ------------------------( merge WP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}wp.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}wp.dta";

/* ------------------------( merge XP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}xp.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}xp.dta";

/* ------------------------( merge YP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}yp.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}yp.dta";

/* ------------------------( merge ZP )------------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}zp.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}zp.dta";

/* --------------------------( done! )-------------------------- */;

label data "SOEPINFO: Magic at Work! http://panel.gsoep.de/soepinfo/";
save  "${MY_OUT_FILE}", replace;
desc;



********************************************************************************
* Producing a long format panel data set (added by Josef Brderl)
********************************************************************************
#delimit cr
use  "${MY_OUT_FILE}", clear

rename persnr id                          //id is convention
replace gp109=gp6401e if gp6401e<.        //copy East-values (1990)

local year=1984                           //renaming to "happy*"
foreach var in ap6801 bp9301 cp9601 dp9801 ep89 fp108 gp109 hp10901 ip10901 jp10901 ///
	           kp10401 lp10401 mp11001 np11701 op12301 pp13501 qp14301 rp13501  ///
			   sp13501 tp14201 up14501 vp154 wp142 xp149 yp15501 zp15701 {	
		rename `var' happy`year'      	
		local year=`year'+1
}

local year=1984                           //renaming to "hhnrakt*"
foreach wave in a b c d e f g h i j k l m n o p q r s t u v w x y z{
		rename `wave'hhnr  hhnrakt`year'      	
		local year=`year'+1
}

drop apop anetto aphrf prgroup gp6401e     	
foreach wave in b c d e f g h i j k l m n o p q r s t u v w x y z{
		drop `wave'pop `wave'netto `wave'pbleib `wave'phrf      	
}                      //drop unnecessary variables to save computation time
	
reshape long happy hhnrakt, i(id) j(year)            //reshape to long format

drop if happy==.                                     //drop empty person-years

mvdecode _all, mv(-3 -1=. \ -2=.a)   //code missing values
bysort id (year): gen pynr = _n      //person-years numbered consecutively 
save ${MY_OUT_PATH}HAPPY2, replace


tab happy, missing                   //person-years
tab happy   if pynr==1, missing      //persons


********************************************************************************
